<?php

namespace App\Http\Controllers;

use App\Models\EID;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    /**
     * Define your validation rules in a property in
     * the controller to reuse the rules.
     */
    protected $validationRules = [
        'eid_id'    => 'required|numeric|digits_between:1,9999',
    ];

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $eids = EID::all();
        $users = array();
        foreach ($eids as $eid) {
            Session::put('connectionName', $eid->enterprise_id);
            $allUsers = User::where('eid_id', '=', $eid->id)->get();
            foreach ($allUsers as $user) {
                $userArray = new Users();
                $userArray->id = $user->id;
                $userArray->name = $user->name;
                $userArray->surname = $user->surname;
                $userArray->email = $user->email;
                $userArray->eid_id = $eid->id;
                array_push($users, $userArray);
            }
        }
        return view('user.index', compact('users', 'eids'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $eids = EID::all();
        return view('user.create', compact('eids'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $v = Validator::make($request->all(), $this->validationRules);
        if ($v->fails())
            return redirect()->back()->withErrors($v->errors())->withInput();

        $eid = EID::where('id', '=', $request->eid_id)->first();
        Session::put('connectionName', $eid->enterprise_id);
        $input = $request->all();
        $user = new User($input);
        $user->name = $request->name;
        $user->surname = $request->surname;
        $user->email = $request->email;
        $user->password = Hash::make($request->password);
        $user->eid_id = $eid->id;

        $exists = User::where('email', '=', $user->email)->first();
        if ($exists)
            return Redirect::route('createUser')->withInput()->with('danger', 'User with email "' . $user->email . '" already exists');

        if ($user->save())
            return Redirect::route('users')->with('success', 'Successfully added user');
        else
            return Redirect::route('createUser')->withInput()->withErrors($user->errors());
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request, $id)
    {
        $eid = EID::find($request->enterprise_id);
        Session::put('connectionName', $eid->enterprise_id);
        $user = User::where('id', '=', $id)
            ->where('eid_id', '=', $eid->id)->first();
        $eids = EID::all();
        return view('user.edit', compact('user', 'eids'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $v = Validator::make($request->all(), $this->validationRules);
        if ($v->fails())
            return redirect()->back()->withErrors($v->errors())->withInput();

        $eid = EID::where('id', '=', $request->eid_id)->first();
        Session::put('connectionName', $eid->enterprise_id);

        $user = User::where('id', '=', $id)
            ->where('eid_id', '=', $eid->id)->first();
        $user->name = $request->name;
        $user->surname = $request->surname;
        $user->eid_id = $request->eid_id;
        $user->email = $request->email;

        if ($request->password != $user->password)
            $user->password = Hash::make($request->password);

        if ($user->update())
            return Redirect::route('users')->with('success', 'Successfully updated user');
        else
            return Redirect::route('editUser', [$id])->withInput()->withErrors($user->errors());
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function showLogin()
    {
        // show the form
        return view('user.login');
    }

    public function doLogin(Request $request)
    {
        Session::put('connectionName', $request->enterprise_id);

        $user = User::where('email', '=', $request->email)->first();

        if ($user)
            $enterprise = EID::where('enterprise_id', '=', $request->enterprise_id)
                ->where('id', '=', $user->eid_id)->first();
        else
            return Redirect::route('login')->withInput()->with('danger', 'Either email address or enterprise id is incorrect');

        // check if the enterprise is active
        if ($enterprise) {
            if ($enterprise->status != 'A')
                return Redirect::route('login')->withInput()->with('danger', 'eid is not active');
        } else
            return Redirect::route('login')->withInput()->with('danger', 'eid does not exist');

        // validate the credentials, create rules for the input
        $users = User::where('email', '=', $request->email)->get();

        // check if email address exists
        if ($users->isEmpty())
            return Redirect::route('login')->withInput()->with('danger', 'Sorry, email address does not exist');

        foreach ($users as $user) {
            $rules = array(
                'email' => 'required|email',
                'password' => 'required|alphaNum|min:3'
            );

            $validator = Validator::make($request->all(), $rules);

            if ($validator->fails())
                return Redirect::route('login')
                    ->withInput($validator)
                    ->withInput()
                    ->with('danger', 'Your login failed, Please try again.');
            else
                $userData = array(
                    'email' => $request->email,
                    'password' => $request->password
                );

            if (Auth::attempt($userData, true)) {
                $date = Carbon::now();
                $id = ($date->year . '-' . $date->month);
                return Redirect::route('dashboard', [$id]);
            } else
                return Redirect::route('login')
                    ->withErrors($validator)
                    ->withInput()
                    ->with('danger', 'Your login failed, Please try again');
        }
    }
    public function doLogout()
    {
        Auth::logout();
        return Redirect::route('login');
    }
}
class Users
{
    public $id;
    public $name;
    public $surname;
    public $email;
    public $eid_id;
}
