<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEidsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('eids')) {
            Schema::create('eids', function (Blueprint $table) {
                $table->id();
                $table->string('name', 50);
                $table->string('enterprise_id', 10);
                $table->string('schemaName', 20);
                $table->enum('status', ['A', 'I'])->default('A');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('eids');
    }
}