<!-- app/views/reports/ClientInformation.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Client Information Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a
        href="{!!URL::route('ClientInfo')!!}">BACK</a></button> @endslot
@endcomponent
<!-- Create Client Information Form... -->

<div class="row">
    <div class="col-xl-12 grid-margin stretch-card ">
        <div class="card">

            <div class="card-body text-center">

                <div class="row">
                    <div class="col-md-12 text-right">
                    </div>
                </div>

                <div id="reportHeader">
                    <h6>Branch: <strong>{{ $branch }}</strong></h6>
                    <h6>Active Clients: <strong>{{ $status }}</strong></h6>
                </div>

                <div class="mt-4">

                    <table class="table table-striped" id="datatable">
                        @if (count($clientArray) > 0)
                        <!-- Table Headings -->
                        <thead>
                            <th>Customer No</th>
                            <th>Surname</th>
                            <th>Firstnames</th>
                            <th>Title</th>
                            <th>ID Number</th>
                            <th>Address Line1</th>
                            <th>Address Line2</th>
                            <th>Address Line3</th>
                            <th>Code</th>
                            <th>Home Telephone</th>
                            <th>Mobile No</th>
                            <th>Email address</th>
                        </thead>

                        <!-- Table Body -->
                        <tbody>

                            @foreach ($clientArray as $client)
                            <tr>
                                <!-- Customer No -->
                                <td class="table-text">
                                    <div>{{ $client->customer }}</div>
                                </td>

                                <!-- Surname -->
                                <td class="table-text">
                                    <div>{{ $client->surname }}</div>
                                </td>

                                <!-- Firstnames -->
                                <td class="table-text">
                                    <div>{{ $client->firstnames }}</div>
                                </td>

                                <!-- Title -->
                                <td class="table-text">
                                    <div>{{ $client->title }}</div>
                                </td>

                                <!-- ID Number -->
                                <td class="table-text">
                                    <div>{{ $client->id_number }}</div>
                                </td>

                                <!-- Address Line1 -->
                                <td class="table-text">
                                    <div>{{ $client->address1 }}</div>
                                </td>

                                <!-- Address Line2 -->
                                <td class="table-text">
                                    <div>{{ $client->address2 }}</div>
                                </td>

                                <!-- Address Line3 -->
                                <td class="table-text">
                                    <div>{{ $client->address3 }}</div>
                                </td>

                                <!-- Postal Code -->
                                <td class="table-text">
                                    <div>{{ $client->code }}</div>
                                </td>

                                <!-- Home Telephone -->
                                <td class="table-text">
                                    <div>{{ $client->hometel }}</div>
                                </td>

                                <!-- Mobile No -->
                                <td class="table-text">
                                    <div>{{ $client->cell2 }}</div>
                                </td>

                                <!-- Email Address -->
                                <td class="table-text">
                                    <div>{{ $client->email }}</div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                        @endif
                    </table>

                </div>

            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        // PDF Export button heading information
        title = "Branch: " +'{!! $branch !!}';
    title = title +"\n" +"Active Clients: " +'{!! $status !!}'
    ;

    //         // PDF Export button heading information
    //         title = "Branch: " +'{!! $branch !!}'+"Active Clients: " +'{!! $status !!}';
    // ;

        $(document).ready(function() {

    $('#datatable').DataTable( {

        "initComplete": function (settings, json) {
    $("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
  },

        //scrollX: true,
       // sScrollXInner: '100%',
        paging: true,
        responsive: false,
        autoWidth: false,

        columnDefs: [ {

            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: "Client Information Report",
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: title,
                title: "Client Information Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ],
        columnDefs: [
            { width: 200, targets: 0 }
        ],

    } );
} );

    </script>

    @section('script')
    <!-- Required datatable js -->
    <!-- <script src="//cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css"></script>  remove this b/c giving { error-->

    <!--<script src="//code.jquery.com/jquery-3.5.1.js"></script>  remove this b/c breaking menu -->
    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/fixedcolumns/3.3.3/js/dataTables.fixedColumns.min.js"></script>

    @endsection

    @endpush
