<!-- app/views/reports/DebtorsAge.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Debtors Age Analysis @endslot
@slot('li_1') @endslot
@endcomponent
<!-- Create Search Debtors Age Form... -->
<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                {!! HTML::ul($errors->all()) !!}
                {!! Form::open(array('route' => 'DebtorsAgeAnalysis', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">
                    <div class="form-group">
                        {!! Form::Label('branch_id', 'Branch') !!}
                        <select class="form-control input-sm form-control-sm" name="branch_id" id="branch_id">
                            <option value="">All Branches</option>
                            @foreach($branches as $branch)
                            <option value="{{$branch->id}}" @if(old('branch_id')==$branch->id)
                                selected="selected"@endif>{{$branch->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('debtor_age', 'Debtor Age') !!}
                        {!! Form::select('debtor_age', array('0'=>'Current and Over', '1'=>'30 Days and Over',
                        '2'=>'60 Days and Over', '3'=>'90 Days and Over', '4'=>'120 Days and Over',
                        '5'=>'Credit Balances'), null, array('class' => 'form-control input-sm
                        form-control-sm', 'required')) !!}
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="bad_type" name="bad_type" checked>
                        <label for="bad_type"> Print Bad-Type-Flagged Clients</label>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="bad_debtors" name="bad_debtors" checked>
                        <label for="bad_debtors"> Print Bad Debtors Type Clients</label>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="handed_over" name="handed_over" checked>
                        <label for="handed_over"> Print Handed Over Type Clients</label>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="written_off" name="written_off">
                        <label for="written_off"> Print Written Off Type Clients</label>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="credit_balances" name="credit_balances" checked>
                        <label for="credit_balances"> Print Credit Balances</label>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="double_spaced" name="double_spaced">
                        <label for="double_spaced"> Print Double Spaced</label>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="clients_telNo" name="clients_telNo">
                        <label for="clients_telNo"> Print Clients Telephone Numbers</label>
                    </div>

                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>


</div>

@endsection
