<!-- app/views/reports/LastSeen.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Last Seen Client Report @endslot
@slot('li_1') @endslot
@endcomponent

<!-- Create Low Sales Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                {!! HTML::ul($errors->all()) !!}
                {!! Form::open(array('route' => 'LastSeenReport', 'method'=>'GET','files'=>true)) !!}


                <div class="col-sm-8 col-md-8">
                    <div class="form-group">
                        {!! Form::Label('branch_id', 'Branch') !!}
                        <select class="form-control input-sm form-control-sm" name="branch_id" id="branch_id">
                            <option value="">All Branches</option>
                            @foreach($branches as $branch)
                            <option value="{{$branch->id}}" @if(old('branch_id')==$branch->id)
                                selected="selected"@endif>{{$branch->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('last_seenDate', 'Last Seen Date') !!}
                        {!! Form::date('last_seenDate', Request::old('last_seenDate'), array('class' => 'form-control
                        input-sm form-control-sm', 'required', 'id'=>'last_seenDate')) !!}
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="ignore_inactiveClients" name="ignore_inactiveClients" checked>
                        <label for="ignore_inactiveClients"> Ignore Inactive Clients</label><br>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="print_detail" name="print_detail" checked>
                        <label for="print_detail"> Print Detail Report</label><br>
                    </div>

                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}

            </div>
        </div>
    </div>
</div>
@endsection

@push('plugin-scripts')
