<!-- app/views/reports/LastSeenReport2.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Last Seen Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('LastSeen')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Client Last Seen Report2 Form... -->
    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Clients last seen before or on: <strong>{{ $lastSeen_date }}</strong></h6>
                        <h6>Printed Date: <strong>{{ $date->format('d/m/Y') }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($branchArray) > 0)
                            @foreach($branchArray as $branch)
                            @if($branch->id == 'A')
                            @continue
                            @endif
                            <!-- Table Headings -->
                            <thead>
                                <th><strong>Branch: {{ $branch->branch_name }}</strong></th>
                            </thead>

                            <!-- Table Body -->
                            <tbody>
                                <tr>
                                    <td class="table-text">
                                        <div>Number of Clients :</div>
                                    </td>

                                    <!-- Customer Count -->
                                    <td class="table-text">
                                        <div>{{ number_format($branch->total) }}</div>
                                    </td>
                                </tr>
                                <tr>
                                    <td class="table-text">
                                        <div>---------------------------------------------------</div>
                                    </td>
                                </tr>
                            </tbody>
                            @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th>Grand Total :</th>
                                <th> {{ number_format($grand_total) }}</th>
                            </tfoot>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        title = "Clients last seen before or on: " +'{!! $lastSeen_date !!}'
title = title +"\n" +"Printed Date:: " +'$date->format('d/m/Y')'
;

        $(document).ready(function() {

$('#datatable').DataTable( {

    "initComplete": function (settings, json) {
$("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
},

        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: "Last Seen Report",
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: title,
                title: "Last Seen Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
