<!-- app/views/reports/LowSales.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Low Sales Report @endslot
@slot('li_1') @endslot
@endcomponent


<!-- Create Low Sales Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                {!! HTML::ul($errors->all()) !!}

                {!! Form::open(array('route' => 'LowSalesReport', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        {!! Form::Label('warehouse_id', 'Warehouse') !!}
                        <select class="form-control input-sm form-control-sm" required name="warehouse_id"
                            id="warehouse_id">
                            <option disabled selected hidden>Select Warehouse</option>
                            @foreach($warehouses as $warehouse)
                            <option value="{{$warehouse->id}}" @if(old('warehouse_id')==$warehouse->id)
                                selected="selected"@endif>{{ $warehouse->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="type_indicator" name="type_indicator">
                        <label for="type_indicator"> Report on All Stock Types</label><br>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('type_id', 'Stock Type') !!}
                        <select class="form-control input-sm form-control-sm" required name="type_id" id="type_id">
                            <option disabled selected hidden>Select Type</option>
                            @foreach($types as $type)
                            <option value="{{$type->id}}" @if(old('type_id')==$type->id)
                                selected="selected"@endif>{{$type->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('min_shelfPeriod', 'Minimum Shelf Period (days)' ) !!}
                        <input class="form-control input-sm form-control-sm" type="text" id="min_shelfPeriod"
                            name="min_shelfPeriod" value="365">
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="zeroQtyOnHand" name="zeroQtyOnHand">
                        <label for="zeroQtyOnHand"> Include Items with Zero Qty On-Hand</label><br>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('supplier_id', 'Supplier') !!}
                        <select class="form-control input-sm form-control-sm" required name="supplier_id"
                            id="supplier_id">
                            <option disabled selected hidden>All Suppliers</option>
                            @foreach($suppliers as $supplier)
                            <option value="{{$supplier->id}}" @if(old('supplier_id')==$supplier->id)
                                selected="selected"@endif>{{$supplier->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('manufacturer', 'Manufacturer') !!}
                        <select class="form-control input-sm form-control-sm" required name="manufacturer"
                            id="manufacturer">
                            <option disabled selected hidden>All Manufacturers</option>
                            @foreach($suppliers as $supplier)
                            <option value="{{$supplier->id}}" @if(old('manufacturer')==$supplier->id)
                                selected="selected"@endif>{{$supplier->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>


</div>
@endsection
