<!-- app/views/reports/PatientFlag.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Patient Flag Report @endslot
@slot('li_1') @endslot
@endcomponent
<!-- Create Patient Flag Search Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                {!! HTML::ul($errors->all()) !!}
                {!! Form::open(array('route' => 'PatientFlagReport', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        {!! Form::Label('branch_id', 'Branch') !!}
                        <select class="form-control input-sm form-control-sm" name="branch_id" required id="branch_id">
                            <option value="">Select Branch</option>
                            @foreach($branches as $branch)
                            <option value="{{$branch->id}}" @if(old('branch_id')==$branch->id)
                                selected="selected"@endif>{{$branch->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('patient_flag', 'Patient Flag To Search') !!}
                        {!! Form::select('patient_flag', array('A'=>'Active Patients', 'I'=>'Inactive Patients'),
                        null, array('class' => 'form-control input-sm form-control-sm', 'required')) !!}
                    </div>

                    <div class="form-group">
                        <label for="startLetter">Names Beginning With Letter </label>
                        <input type="text" id="startLetter" name="startLetter" checked>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="print_detail" name="print_detail" checked>
                        <label for="print_detail"> Print Detail Report</label><br>
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>

        </div>
    </div>


</div>

@endsection
