<!-- app/views/reports/PatientsWithoutMicrochip.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Patients Without Microchip @endslot
@slot('li_1') @endslot
@endcomponent
<!-- Create Patients Without Microchip Search Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">

                {!! HTML::ul($errors->all()) !!}
                {!! Form::open(array('route' => 'PatientsWithoutChipReport', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        {!! Form::Label('branch_id', 'Branch') !!}
                        <select class="form-control input-sm form-control-sm" name="branch_id" required id="branch_id">
                            <option value="">Select Branch</option>
                            @foreach($branches as $branch)
                                <option value="{{$branch->id}}" @if(old('branch_id')==$branch->id)
                                selected="selected"@endif>{{$branch->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('patType_id', 'Patient Type') !!}
                        <select class="form-control input-sm form-control-sm" required name="patType_id"
                            id="patType_id">
                            <option value="">Select Patient Type</option>
                            @foreach($patienttypes as $patienttype)
                            <option value="{{$patienttype->id}}" @if(old('patType_id')==$patienttype->id)
                                selected="selected"@endif>{{$patienttype->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="patient_status" name="patient_status" checked>
                        <label for="patient_status"> Print Active Patients</label><i class="ri-question-line ri-lg ml-4"
                            data-toggle="tooltip" data-placement="right"
                            title="Select whether to include active patients or not"></i>
                    </div>

                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

@endsection
