<!-- app/views/reports/searchscheduledDrugs.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection

@section('content')
@component('components.breadcrumb')

@slot('title') Drugs Ledger by Schedule @endslot
@slot('li_1') @endslot
@endcomponent
<!-- Create Daily Tracker Search Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">
                {!! HTML::ul($errors->all()) !!}

                {!! Form::open(array('route' => 'ScheduledDrugsReport', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        {!! Form::label('start_date', 'Start Date') !!}
                        {!! Form::date('start_date', Request::old('start_date'), array('class' => 'form-control
                        form-control-sm', 'required', 'id'=>'start_date')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::label('end_date', 'End Date') !!}
                        {!! Form::date('end_date', Request::old('end_date'), array('class' => 'form-control
                        form-control-sm', 'required', 'id'=>'end_date')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::Label('warehouse_id', 'Warehouse') !!}
                        <select class="form-control input-sm form-control-sm" required name="warehouse_id"
                            id="warehouse_id">
                            <option disabled selected hidden>Select Warehouse</option>
                            @foreach($warehouses as $warehs)
                            <option value="{{$warehs->id}}" @if(old('warehouse_id')==$warehs->id)
                                selected="selected"@endif>{{$warehs->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('start_schedule', 'Start Schedule') !!}
                        {!! Form::text('start_schedule', Request::old('start_schedule'), array('class' => 'form-control
                        form-control-sm', 'required', 'id'=>'start_schedule')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::label('end_schedule', 'End Schedule') !!}
                        {!! Form::text('end_schedule', Request::old('end_schedule'), array('class' => 'form-control
                        form-control-sm', 'required', 'id'=>'end_schedule')) !!}
                    </div>
                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>

</div>
@endsection
