<!-- app/views/reports/StockTaking.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Stock Taking Worksheets @endslot
@slot('li_1') @endslot
@endcomponent
<!-- Create Stock Taking Search Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">

                {!! HTML::ul($errors->all()) !!}
                {!! Form::open(array('route' => 'StockTakingReport', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        {!! Form::Label('warehouse_id', 'Warehouse') !!}
                        <select class="form-control input-sm form-control-sm" required name="warehouse_id" id="warehouse_id">
                            <option value="">Select Warehouse</option>
                            @foreach($warehouses as $warehouse)
                                <option value="{{$warehouse->id}}" @if(old('warehouse_id')==$warehouse->id)
                                selected="selected"@endif>{{$warehouse->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::Label('type_id', 'Stock Type') !!}
                        <select class="form-control input-sm form-control-sm" required name="type_id" id="type_id">
                            <option value="">Select Type</option>
                            @foreach($types as $type)
                                <option value="{{$type->id}}" @if(old('type_id')==$type->id)
                                selected="selected"@endif>{{$type->description}}</option>
                            @endforeach
                        </select>
                    </div>
                
                    <div class="form-group">
                        <input type="checkbox" id="letterRanges" name="letterRanges" checked>
                        <label for="letterRanges"> Use Letter Ranges</label>
                    </div>

                    <div class="form-group">
                        <label for="startLetter">Start Letter</label>
                        <input type="text" id="startLetter" name="startLetter" checked class='form-control input-sm
                        form-control-sm'>
                    </div>

                    <div class="form-group">
                        <label for="endLetter">End Letter</label>
                        <input type="text" id="endLetter" name="endLetter" checked class='form-control input-sm
                        form-control-sm'>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="costPrice" name="costPrice">
                        <label for="costPrice"> Print Cost Price</label>
                    </div>

                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>
@endsection
