<!-- app/views/reports/StockTransRECRep.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') STOCK TRANSACTION REPORT @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a
        href="{!!URL::route('StockTransaction')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Stock Trans Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">

                        <h6>Transaction Type: <strong>{{ $transaction }}</strong></h6>
                        <h6>Sub Type: <strong>{{ $sub_transaction }}</strong></h6>
                        <h6>Branch: <strong>{{ $branch }}</strong></h6>
                        <h6>Warehouse: <strong>{{ $warehouse }}</strong></h6>
                        <h6>Stock Type: <strong>{{ $type }}</strong></h6>
                        <h6>Stock Code: <strong>{{ $code }}</strong></h6>
                        <h6>Supplier: <strong>{{ $supplier }}</strong></h6>
                        <h6>Manufacturer: <strong>{{ $manufacturer }}</strong></h6>
                        <h6>For Period: <strong>{{ $start_date }}</strong> To: <strong>{{ $end_date }}</strong></h6>
                        <h6>Printed on: <strong>{{ $date->format('d/m/Y') }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" style="width: auto" id="datatable">
                            @if(count($stktras) > 0)
                                <!-- Table Headings -->
                                <thead>
                                    <th>Date</th>
                                    <th>Description</th>
                                    <th>User</th>
                                    <th>Whs</th>
                                    <th>Adjust Qty</th>
                                    <th>Purchase Price</th>
                                    <th>Old Qty</th>
                                    <th>New Qty</th>
                                    <th>Old Cost</th>
                                    <th>New Cost</th>
                                    <th>Old Sales</th>
                                    <th>New Sales</th>
                                    <th>Supplier Name</th>
                                    <th>Invoice No</th>
                                </thead>

                                @foreach($stktras as $stktra)
                                    <!-- Table Body -->
                                    <tbody>
                                        <tr>
                                            <!-- Date -->
                                            <td class="table-text">
                                                <div>{{ $stktra->date }}</div>
                                            </td>

                                            <!-- Description -->
                                            <td class="table-text">
                                                <div>{{ $stktra->description }}</div>
                                            </td>

                                            <!-- User -->
                                            <td class="table-text">
                                                <div>{{ $stktra->rep }}</div>
                                            </td>

                                            <!-- Warehouse -->
                                            <td class="table-text">
                                                <div>{{ $stktra->warehs }}</div>
                                            </td>

                                            <!-- Old Amount -->
                                            <td class="table-text">
                                                <div>{{ number_format($stktra->old_value, 2) }}</div>
                                            </td>

                                            <!-- New Amount -->
                                            <td class="table-text">
                                                <div>{{ number_format($stktra->new_value, 2) }}</div>
                                            </td>

                                            <!-- Old Qty -->
                                            <td class="table-text">
                                                <div>{{ number_format($stktra->old_qty, 2) }}</div>
                                            </td>

                                            <!-- New Qty -->
                                            <td class="table-text">
                                                <div>{{ number_format($stktra->new_qty, 2) }}</div>
                                            </td>

                                            <!-- Old Cost Price -->
                                            <td class="table-text">
                                                <div>{{ number_format($stktra->old_cost_price, 2) }}</div>
                                            </td>

                                            <!-- New Cost Price -->
                                            <td class="table-text">
                                                <div>{{ number_format($stktra->new_cost_price, 2) }}</div>
                                            </td>

                                            <!-- Old Sales Price -->
                                            <td class="table-text">
                                                <div>{{ number_format($stktra->old_sales_price, 2) }}</div>
                                            </td>

                                            <!-- New Sales Price -->
                                            <td class="table-text">
                                                <div>{{ number_format($stktra->new_sales_price, 2) }}</div>
                                            </td>

                                            <!-- Supplier Name -->
                                            <td class="table-text">
                                                <div>{{ $stktra->supplierName }}</div>
                                            </td>

                                            <!-- Invoice No -->
                                            <td class="table-text">
                                                <div>{{ $stktra->supplier_invno }}</div>
                                            </td>
                                        </tr>
                                    </tbody>
                                @endforeach
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="panel panel-default">
        <div class="panel-heading">
            <div class="row">
                <div class="col-xs-6">
                    <h4>STOCK TRANSACTION REPORT</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <h4>Transaction Type: {{ $transaction }}</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <h4>Sub Type: {{ $sub_transaction }}</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <h4>Branch: {{ $branch }}</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <h4>Warehouse: {{ $warehouse }}</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <h4>Stock Type: {{ $type }}</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <h4>Stock Code: {{ $code }}</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <h4>Supplier: {{ $supplier }}</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <h4>Manufacturer: {{ $manufacturer }}</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <h4>For Period: {{ $start_date }} To: {{ $end_date }}</h4>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-6">
                    <h4>Printed on: {{ $date->format('d/m/Y') }}</h4>
                </div>
            </div>
        </div>

        <div class="panel-body">
            <table class="table table-striped" style="width: auto" id="datatable">
                @if(count($stktras) > 0)
                <!-- Table Headings -->
                <thead>
                    <th>Date</th>
                    <th>Description</th>
                    <th>User</th>
                    <th>Whs</th>
                    <th>Adjust Qty</th>
                    <th>Purchase Price</th>
                    <th>Old Qty</th>
                    <th>New Qty</th>
                    <th>Old Cost</th>
                    <th>New Cost</th>
                    <th>Old Sales</th>
                    <th>New Sales</th>
                    <th>Supplier Name</th>
                    <th>Invoice No</th>
                </thead>

                @foreach($stktras as $stktra)

                <!-- Table Body -->
                <tbody>
                    <tr>
                        <!-- Date -->
                        <td class="table-text">
                            <div>{{ $stktra->date }}</div>
                        </td>

                        <!-- Description -->
                        <td class="table-text">
                            <div>{{ $stktra->description }}</div>
                        </td>

                        <!-- User -->
                        <td class="table-text">
                            <div>{{ $stktra->rep }}</div>
                        </td>

                        <!-- Warehouse -->
                        <td class="table-text">
                            <div>{{ $stktra->warehs }}</div>
                        </td>

                        <!-- Old Amount -->
                        <td class="table-text">
                            <div>{{ number_format($stktra->old_value, 2) }}</div>
                        </td>

                        <!-- New Amount -->
                        <td class="table-text">
                            <div>{{ number_format($stktra->new_value, 2) }}</div>
                        </td>

                        <!-- Old Qty -->
                        <td class="table-text">
                            <div>{{ number_format($stktra->old_qty, 2) }}</div>
                        </td>

                        <!-- New Qty -->
                        <td class="table-text">
                            <div>{{ number_format($stktra->new_qty, 2) }}</div>
                        </td>

                        <!-- Old Cost Price -->
                        <td class="table-text">
                            <div>{{ number_format($stktra->old_cost_price, 2) }}</div>
                        </td>

                        <!-- New Cost Price -->
                        <td class="table-text">
                            <div>{{ number_format($stktra->new_cost_price, 2) }}</div>
                        </td>

                        <!-- Old Sales Price -->
                        <td class="table-text">
                            <div>{{ number_format($stktra->old_sales_price, 2) }}</div>
                        </td>

                        <!-- New Sales Price -->
                        <td class="table-text">
                            <div>{{ number_format($stktra->new_sales_price, 2) }}</div>
                        </td>

                        <!-- Supplier Name -->
                        <td class="table-text">
                            <div>{{ $stktra->supplierName }}</div>
                        </td>

                        <!-- Invoice No -->
                        <td class="table-text">
                            <div>{{ $stktra->supplier_invno }}</div>
                        </td>
                    </tr>
                </tbody>
                @endforeach
                @endif
            </table>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        $(document).ready(function() {

$('#datatable').DataTable( {

"initComplete": function (settings, json) {
$("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
},

        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: null,
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: 'title',
                title: "Debtors Age Analysis Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

} );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
