<!-- app/views/reports/TopClientBySales.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Top Client By Sales Report @endslot
@slot('li_1') @endslot
@endcomponent
<!-- Create Top Client Search Form... -->

<div class="row">
    <div class="col-xl-6 grid-margin stretch-card">
        <div class="card">
            <div class="card-body">

                {!! HTML::ul($errors->all()) !!}
                {!! Form::open(array('route' => 'TopClientReport', 'method'=>'GET','files'=>true)) !!}

                <div class="col-sm-8 col-md-8">

                    <div class="form-group">
                        {!! Form::Label('branch_id', 'Branch') !!}
                        <select class="form-control input-sm form-control-sm" name="branch_id" id="branch_id">
                            <option value="">All Branches</option>
                            @foreach($branches as $branch)
                                <option value="{{$branch->id}}" @if(old('branch_id')==$branch->id)
                                selected="selected"@endif>{{$branch->description}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        {!! Form::label('start_date', 'Start Date') !!}
                        {!! Form::date('start_date', Request::old('start_date'), array('class' => 'form-control input-sm
                        form-control-sm', 'required', 'id'=>'start_date')) !!}
                    </div>

                    <div class="form-group">
                        {!! Form::label('end_date', 'End Date') !!}
                        {!! Form::date('end_date', Request::old('end_date'), array('class' => 'form-control input-sm
                        form-control-sm', 'required', 'id'=>'end_date')) !!}
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="ignoreSystemAccounts" name="ignoreSystemAccounts" checked>
                        <label for="ignoreSystemAccounts"> Ignore System Accounts</label>
                    </div>

                    <div class="form-group">
                        <input type="checkbox" id="ignoreInactiveAccounts" name="ignoreInactiveAccounts" checked>
                        <label for="ignoreInactiveAccounts"> Ignore Inactive Accounts</label>
                    </div>

                </div>

                <div class="col-xs-12 col-sm-12 col-md-12">
                    {!! Form::submit('Submit', array('class' => 'btn btn-sm btn-primary')) !!}
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>

@endsection
