<!-- app/views/reports/TotalConsultationReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') Total Consultation Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a
        href="{!!URL::route('TotalConsultations')!!}">BACK</a>
    @endslot
    @endcomponent
    <!-- Create Total Consultation Report Form... -->
    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        <h6>Report From: <strong>{{ $start_date }}</strong> To: <strong>{{ $end_date }}</strong></h6>
                        <h6>Printed Date: <strong>{{ $date->format('d/m/Y') }}</strong></h6>
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($totalConsult) > 0)
                            @foreach($branchArray as $branch)
                            @if($branch->id == 'A')
                            @continue
                            @endif
                            <thead>
                                <th><strong>Branch : {{ $branch->branch_name }}</strong></th>
                            </thead>
                            @foreach($vetArray as $vet)
                            @if($vet->branch_id != $branch->id)
                            @continue
                            @endif
                            <thead>
                                <th><strong>Vet : {{ $vet->vet_user }}</strong></th>
                            </thead>
                            <thead>
                                <th>Invoice No</th>
                                <th>Amount</th>
                                <th>Discount</th>
                                <th>Cost</th>
                                <th>Tax</th>
                            </thead>
                            @foreach($totalConsult as $totConsult)
                            @if($totConsult->vet_id != $vet->vet_code)
                            @continue
                            @endif
                            @if($totConsult->branch_id != $branch->id)
                            @continue
                            @endif
                            <!-- Table Body -->
                            <tbody>
                                <tr>
                                    <td class="table-text">
                                        <div>{{ $totConsult->invoice_no }}</div>
                                    </td>

                                    <!-- Cost Price -->
                                    <td class="table-text">
                                        <div>{{ number_format($totConsult->amount, 2) }}</div>
                                    </td>

                                    <!-- Sales Price -->
                                    <td class="table-text">
                                        <div>{{ number_format($totConsult->discount, 2) }}</div>
                                    </td>

                                    <!-- Cost Price -->
                                    <td class="table-text">
                                        <div>{{ number_format($totConsult->cost, 2) }}</div>
                                    </td>

                                    <!-- Sales Price -->
                                    <td class="table-text">
                                        <div>{{ number_format($totConsult->tax, 2) }}</div>
                                    </td>
                                </tr>
                            </tbody>
                            @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th><strong>Vet Total</strong></th>
                                <th>{{ number_format($vet->tot_amount, 2) }}</th>
                                <th>{{ number_format($vet->tot_discount, 2) }}</th>
                                <th>{{ number_format($vet->tot_cost, 2) }}</th>
                                <th>{{ number_format($vet->tot_tax, 2) }}</th>
                            </tfoot>
                            @endforeach
                            <tfoot></tfoot>
                            <tfoot>
                                <th><strong>Branch Total</strong></th>
                                <th>{{ number_format($branch->tot_amount, 2) }}</th>
                                <th>{{ number_format($branch->tot_discount, 2) }}</th>
                                <th>{{ number_format($branch->tot_cost, 2) }}</th>
                                <th>{{ number_format($branch->tot_tax, 2) }}</th>
                            </tfoot>
                            @endforeach
                            <tfoot>
                                <th><strong>Grand Total</strong></th>
                                <th>{{ number_format($grand_amount, 2) }}</th>
                                <th>{{ number_format($grand_discount, 2) }}</th>
                                <th>{{ number_format($grand_cost, 2) }}</th>
                                <th>{{ number_format($grand_tax, 2) }}</th>
                            </tfoot>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection
    @push('plugin-scripts')

    <script>
        $(document).ready(function() {

$('#datatable').DataTable( {

    "initComplete": function (settings, json) {
$("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
},

        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: null,
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: title,
                title: "Debtors Age Analysis Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
