<!-- app/views/reports/TotalOutstandingDebt.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')
@endsection
<?php
$id = ($date->year . '-' . $date->month);
?>
@section('content')
@component('components.breadcrumb')
@slot('title') Total Debtors Outstanding @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="{!!URL::route('dashboard', $id)!!}">BACK</a>
@endslot
@endcomponent
<!-- Create Total Outstanding Debt Form... -->

<div class="row">
    <div class="col-xl-12 grid-margin stretch-card ">
        <div class="card">

            <div class="card-body text-center">

                <div id="reportHeader">

                    <h6>Printed on: <strong>{{ $date->format('d/m/Y') }}</strong></h6>

                </div>

                <div class="mt-4">

                    <table class="table table-striped" id="datatable">
                        @if(count($totalDebts) > 0)
                            <?php
                                $balance = 0; $current = 0; $age30 = 0; $age60 =0; $age90 = 0; $age120 = 0;
                            ?>
                            <!-- Table Headings -->
                            <thead>
                                <th>Branch</th>
                                <th>Balance</th>
                                <th>Current</th>
                                <th>30 Days</th>
                                <th>60 Days</th>
                                <th>90 Days</th>
                                <th>120 Days</th>
                            </thead>

                            @foreach($totalDebts as $debts)
                                @if($debts->description == '                              ')
                                    @continue
                                @endif
                                <!-- Table Body -->
                                <tbody>
                                    <tr>
                                        <!-- Branch -->
                                        <td class="table-text">
                                            <div>{{ $debts->description }}</div>
                                        </td>

                                        <!-- Balance -->
                                        <td class="table-text">
                                            <div>{{ number_format($debts->balance, 2) }}</div>
                                        </td>

                                        <!-- Current -->
                                        <td class="table-text">
                                            <div>{{ number_format($debts->current, 2) }}</div>
                                        </td>

                                        <!-- Age 30 -->
                                        <td class="table-text">
                                            <div>{{ number_format($debts->age30, 2) }}</div>
                                        </td>

                                        <!-- Age 60 -->
                                        <td class="table-text">
                                            <div>{{ number_format($debts->age60, 2) }}</div>
                                        </td>

                                        <!-- Age 90 -->
                                        <td class="table-text">
                                            <div>{{ number_format($debts->age90, 2) }}</div>
                                        </td>

                                        <!-- Age 120 -->
                                        <td class="table-text">
                                            <div>{{ number_format($debts->age120, 2) }}</div>
                                        </td>
                                    </tr>
                                </tbody>
                                <?php
                                    $balance = $balance + $debts->balance;
                                    $current = $current + $debts->current;
                                    $age30 = $age30 + $debts->age30;
                                    $age60 = $age60 + $debts->age60;
                                    $age90 = $age90 + $debts->age90;
                                    $age120 = $age120 + $debts->age120;
                                ?>
                            @endforeach
                            <tfoot>
                                <th>Total Debtors are</th>
                                <th>{{ number_format($balance, 2) }}</th>
                                <th>{{ number_format($current, 2) }}</th>
                                <th>{{ number_format($age30, 2) }}</th>
                                <th>{{ number_format($age60, 2) }}</th>
                                <th>{{ number_format($age90, 2) }}</th>
                                <th>{{ number_format($age120, 2) }}</th>
                            </tfoot>
                        @endif
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('plugin-scripts')

<script>
    $(document).ready(function() {

$('#datatable').DataTable( {

    "initComplete": function (settings, json) {
$("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
},

    paging: true,
    responsive: false,
    columnDefs: [ {
        targets: [ 0 ],
        orderData: [ 0, 1 ]
    }, {
        targets: [ 1 ],
        orderData: [ 1, 0 ]
    }, {
        targets: [ 4 ],
        orderData: [ 4, 0 ]
    } ],

    dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: null,
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: 'title',
                title: "Debtors Age Analysis Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

</script>

@section('script')

<script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

@endsection

@endpush
