<!-- app/views/reports/UserTravelReport.blade.php -->
@extends('layout.layout')
@section('title') Dashboard @endsection
@section('css')

@endsection
@section('content')
@component('components.breadcrumb')
@slot('title') User Travel Detail Report @endslot
@slot('li_1') <button type="button" class="btn btn-sm btn-primary"><a href="UserTravel">BACK</a>
    @endslot
    @endcomponent
    <!-- Create User Travel Report Form... -->

    <div class="row">
        <div class="col-xl-12 grid-margin stretch-card ">
            <div class="card">

                <div class="card-body text-center">

                    <div id="reportHeader">
                        @if($start_date == null)
                            <h6>Travel Detail Report For User: <strong>{{ $vet->user_name }}</strong></h6>
                        @else
                            <h6>Travel Detail Report For Period: <strong>{{ $start_date }}</strong> To:
                            <strong>{{ $end_date }}</strong></h6>
                            <h6>For User: <strong>{{ $vet->user_name }}</strong></h6>
                        @endif
                    </div>

                    <div class="mt-4">

                        <table class="table table-striped" id="datatable">
                            @if (count($invoices) > 0)
                                <thead>
                                    <th>Date</th>
                                    <th>Client</th>
                                    <th>Description</th>
                                    <th>Quantity</th>
                                    <th>Net Amount</th>
                                    <th>Discount</th>
                                    <th>VAT</th>
                                    <th>Cost</th>
                                </thead>

                                <!-- Table Body -->
                                <tbody>
                                    @foreach($invoices as $invoive)
                                        <tr>
                                            <!-- Date -->
                                            <td class="table-text">
                                                <div>{{ $invoive->invoice_date }}</div>
                                            </td>

                                            <!-- Customer -->
                                            <td class="table-text">
                                                <div>{{ $invoive->customer }}</div>
                                            </td>

                                            <!-- Description -->
                                            <td class="table-text">
                                                <div>{{ $invoive->description }}</div>
                                            </td>

                                            <!-- Quantity -->
                                            <td class="table-text">
                                                <div>{{ $invoive->qty_shipped }}</div>
                                            </td>

                                            <!-- Net Amount -->
                                            <td class="table-text">
                                                <div>{{ number_format($invoive->amount, 2) }}</div>
                                            </td>

                                            <!-- Discount -->
                                            <td class="table-text">
                                                <div>{{ number_format($invoive->discount, 2) }}</div>
                                            </td>

                                            <!-- VAT -->
                                            <td class="table-text">
                                                <div>{{ number_format($invoive->tax, 2) }}</div>
                                            </td>

                                            <!-- Cost -->
                                            <td class="table-text">
                                                <div>{{ number_format($invoive->cost, 2) }}</div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            @endif
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection

    @push('plugin-scripts')

    <script>
        $(document).ready(function() {

    $('#datatable').DataTable( {

        "initComplete": function (settings, json) {
    $("#datatable").wrap("<div style='overflow:auto; width:100%;position:relative;'></div>");
  },

        paging: true,
        responsive: false,
        columnDefs: [ {
            targets: [ 0 ],
            orderData: [ 0, 1 ]
        }, {
            targets: [ 1 ],
            orderData: [ 1, 0 ]
        }, {
            targets: [ 4 ],
            orderData: [ 4, 0 ]
        } ],

        dom: 'lBfrtip',
        buttons: [
            'copy',
            {
                extend: 'excel',
                messageTop: 'reportHeader',
                title: null,
            },
            {
                extend: 'pdfHtml5',
                messageBottom: null,
                messageTop: "title",
                title: "Debtors Age Analysis Report",
                orientation: 'landscape',
                pageSize: 'LEGAL'
            },

        ]

    } );
} );

    </script>

    @section('script')

    <script src="//cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/rowreorder/1.2.8/js/dataTables.rowReorder.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>

    @endsection

    @endpush
