<!-- app/views/user/add.blade.php -->

@extends('layout/app')

@section('content')
<!-- Create User Form... -->

<div class="page-content d-flex align-items-center justify-content-center">

    <div class="row w-100 mr-5 auth-page">
        <div class="col-md-8 col-xl-6 mx-auto">
            <div class="card">
                <div class="card-body">

                    <h4 class="mb-3">Create New User</h4>

                    <!-- if there are creation errors, they will show here -->

                    {!! HTML::ul($errors->all()) !!}
                    {!! Form::model(new App\Models\User, ['route' => ['storeUser']]) !!}

                    <div class="col-md-8">

                        <div class="form-group form-group-sm">
                            {!! Form::label('name', 'Name:') !!}
                            {!! Form::text('name', Request::old('name'), array('class' => 'form-control form-control-sm
                            input-sm', 'required'))
                            !!}
                        </div>

                        <div class="form-group form-group-sm">
                            {!! Form::label('surname', 'Surname:') !!}
                            {!! Form::text('surname', Request::old('surname'), array('class' => 'form-control
                            form-control-sm
                            input-sm',
                            'required')) !!}
                        </div>

                        <div class="form-group form-group-sm">
                            {!! Form::label('eid_id', 'Enterprise ID:') !!}
                            <select class="form-control form-control-sm
                            input-sm" required name="eid_id" id="eid_id">
                                <option value="">Select EID</option>
                                @foreach($eids as $eid)
                                <option value="{{ $eid->id }}">{{ $eid->enterprise_id }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group form-group-sm">
                            {!! Form::label('email', 'Email:') !!}
                            {!! Form::email('email', Request::old('email'), array('class' => 'form-control
                            form-control-sm
                            input-sm',
                            'required')) !!}
                        </div>

                        <div class="form-group form-group-sm">
                            {!! Form::label('password', 'Password:') !!}
                            {!! Form::password('password', array('class' => 'form-control form-control-sm
                            input-sm', 'required')) !!}
                        </div>

                        @auth()
                        <a href="{!!URL::route('users')!!}" class="btn btn-sm btn-secondary" role="button">Cancel</a>
                        @else
                        <a href="{!!URL::previous()!!}" class="btn btn-sm btn-secondary" role="button">Back</a>
                        @endif
                        {!! Form::submit('Create', array('class' => 'btn btn-sm btn-info')) !!}
                        {!! Form::close() !!}

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
